"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def generate(
    hub, ctx, app_id: str, backend_environment_name: str, resource_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Generates a model schema for an existing backend API resource.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        resource_name(str): The name of this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.api.model.generate(
                ctx, app_id=value, backend_environment_name=value, resource_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.api.model.generate app_id=value, backend_environment_name=value, resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="generate_backend_api_models",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "ResourceName": resource_name,
        },
    )


async def get_all(
    hub, ctx, app_id: str, backend_environment_name: str, resource_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Generates a model schema for existing backend API resource.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        resource_name(str): The name of this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.api.model.get_all(
                ctx, app_id=value, backend_environment_name=value, resource_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.api.model.get_all app_id=value, backend_environment_name=value, resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="get_backend_api_models",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "ResourceName": resource_name,
        },
    )
