"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    app_id: str,
    backend_environment_name: str,
    resource_config: Dict,
    resource_name: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new backend API resource.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        resource_config(Dict): The resource configuration for this request.
        resource_name(str): The name of this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.api.init.create(
                ctx,
                app_id=value,
                backend_environment_name=value,
                resource_config=value,
                resource_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.api.init.create app_id=value, backend_environment_name=value, resource_config=value, resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="create_backend_api",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "ResourceConfig": resource_config,
            "ResourceName": resource_name,
        },
    )


async def delete(
    hub,
    ctx,
    app_id: str,
    backend_environment_name: str,
    resource_name: str,
    resource_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing backend API resource.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        resource_config(Dict, optional): Defines the resource configuration for the data model in your Amplify project. Defaults to None.
        resource_name(str): The name of this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.api.init.delete(
                ctx, app_id=value, backend_environment_name=value, resource_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.api.init.delete app_id=value, backend_environment_name=value, resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="delete_backend_api",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "ResourceConfig": resource_config,
            "ResourceName": resource_name,
        },
    )


async def get(
    hub,
    ctx,
    app_id: str,
    backend_environment_name: str,
    resource_name: str,
    resource_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the details for a backend API.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        resource_config(Dict, optional): Defines the resource configuration for the data model in your Amplify project. Defaults to None.
        resource_name(str): The name of this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.api.init.get(
                ctx, app_id=value, backend_environment_name=value, resource_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.api.init.get app_id=value, backend_environment_name=value, resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="get_backend_api",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "ResourceConfig": resource_config,
            "ResourceName": resource_name,
        },
    )


async def update(
    hub,
    ctx,
    app_id: str,
    backend_environment_name: str,
    resource_name: str,
    resource_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing backend API resource.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        resource_config(Dict, optional): Defines the resource configuration for the data model in your Amplify project. Defaults to None.
        resource_name(str): The name of this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.api.init.update(
                ctx, app_id=value, backend_environment_name=value, resource_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.api.init.update app_id=value, backend_environment_name=value, resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="update_backend_api",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "ResourceConfig": resource_config,
            "ResourceName": resource_name,
        },
    )
