"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def remove(hub, ctx, app_id: str, clean_amplify_app: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Removes all backend environments from your Amplify project.

    Args:
        app_id(str): The app ID.
        clean_amplify_app(bool, optional): Cleans up the Amplify Console app if this value is set to true. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.all_backend.remove(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.all_backend.remove app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="remove_all_backends",
        op_kwargs={"AppId": app_id, "CleanAmplifyApp": clean_amplify_app},
    )
