"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, app_id: str, branch_name: str, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new webhook on an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        branch_name(str):  The name for a branch that is part of an Amplify app. .
        description(str, optional):  The description for a webhook. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.webhook.create(ctx, app_id=value, branch_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.webhook.create app_id=value, branch_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="create_webhook",
        op_kwargs={
            "appId": app_id,
            "branchName": branch_name,
            "description": description,
        },
    )


async def delete(hub, ctx, webhook_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a webhook.

    Args:
        webhook_id(str):  The unique ID for a webhook. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.webhook.delete(ctx, webhook_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.webhook.delete webhook_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="delete_webhook",
        op_kwargs={"webhookId": webhook_id},
    )


async def get(hub, ctx, webhook_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns the webhook information that corresponds to a specified webhook ID.

    Args:
        webhook_id(str):  The unique ID for a webhook. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.webhook.get(ctx, webhook_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.webhook.get webhook_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="get_webhook",
        op_kwargs={"webhookId": webhook_id},
    )


async def list_all(
    hub, ctx, app_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of webhooks for an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        next_token(str, optional):  A pagination token. Set to null to start listing webhooks from the start. If non-null,the pagination token is returned in a result. Pass its value in here to list more webhooks. . Defaults to None.
        max_results(int, optional):  The maximum number of records to list in a single response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.webhook.list_all(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.webhook.list_all app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="list_webhooks",
        op_kwargs={"appId": app_id, "nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub, ctx, webhook_id: str, branch_name: str = None, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Updates a webhook.

    Args:
        webhook_id(str):  The unique ID for a webhook. .
        branch_name(str, optional):  The name for a branch that is part of an Amplify app. . Defaults to None.
        description(str, optional):  The description for a webhook. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.webhook.update(ctx, webhook_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.webhook.update webhook_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="update_webhook",
        op_kwargs={
            "webhookId": webhook_id,
            "branchName": branch_name,
            "description": description,
        },
    )
