"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, app_id: str, branch_name: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a job for a branch of an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        branch_name(str):  The name for the branch, for the job. .
        job_id(str):  The unique ID for the job. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.job.delete(
                ctx, app_id=value, branch_name=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.job.delete app_id=value, branch_name=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="delete_job",
        op_kwargs={"appId": app_id, "branchName": branch_name, "jobId": job_id},
    )


async def get(hub, ctx, app_id: str, branch_name: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns a job for a branch of an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        branch_name(str):  The branch name for the job. .
        job_id(str):  The unique ID for the job. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.job.get(
                ctx, app_id=value, branch_name=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.job.get app_id=value, branch_name=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="get_job",
        op_kwargs={"appId": app_id, "branchName": branch_name, "jobId": job_id},
    )


async def start(
    hub,
    ctx,
    app_id: str,
    branch_name: str,
    job_type: str,
    job_id: str = None,
    job_reason: str = None,
    commit_id: str = None,
    commit_message: str = None,
    commit_time: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Starts a new job for a branch of an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        branch_name(str):  The branch name for the job. .
        job_id(str, optional):  The unique ID for an existing job. This is required if the value of jobType is RETRY. . Defaults to None.
        job_type(str):  Describes the type for the job. The job type RELEASE starts a new job with the latest change from the specified branch. This value is available only for apps that are connected to a repository. The job type RETRY retries an existing job. If the job type value is RETRY, the jobId is also required. .
        job_reason(str, optional):  A descriptive reason for starting this job. . Defaults to None.
        commit_id(str, optional):  The commit ID from a third-party repository provider for the job. . Defaults to None.
        commit_message(str, optional):  The commit message from a third-party repository provider for the job. . Defaults to None.
        commit_time(str, optional):  The commit date and time for the job. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.job.start(
                ctx, app_id=value, branch_name=value, job_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.job.start app_id=value, branch_name=value, job_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="start_job",
        op_kwargs={
            "appId": app_id,
            "branchName": branch_name,
            "jobId": job_id,
            "jobType": job_type,
            "jobReason": job_reason,
            "commitId": commit_id,
            "commitMessage": commit_message,
            "commitTime": commit_time,
        },
    )


async def stop(hub, ctx, app_id: str, branch_name: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Stops a job that is in progress for a branch of an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        branch_name(str):  The name for the branch, for the job. .
        job_id(str):  The unique id for the job. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.job.stop(
                ctx, app_id=value, branch_name=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.job.stop app_id=value, branch_name=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="stop_job",
        op_kwargs={"appId": app_id, "branchName": branch_name, "jobId": job_id},
    )
