"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    app_id: str,
    domain_name: str,
    sub_domain_settings: List,
    enable_auto_sub_domain: bool = None,
    auto_sub_domain_creation_patterns: List = None,
    auto_sub_domain_iam_role: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new domain association for an Amplify app. This action associates a custom domain with the Amplify app

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        domain_name(str):  The domain name for the domain association. .
        enable_auto_sub_domain(bool, optional):  Enables the automated creation of subdomains for branches. . Defaults to None.
        sub_domain_settings(List):  The setting for the subdomain. .
        auto_sub_domain_creation_patterns(List, optional):  Sets the branch patterns for automatic subdomain creation. . Defaults to None.
        auto_sub_domain_iam_role(str, optional):  The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.domain_association.create(
                ctx, app_id=value, domain_name=value, sub_domain_settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.domain_association.create app_id=value, domain_name=value, sub_domain_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="create_domain_association",
        op_kwargs={
            "appId": app_id,
            "domainName": domain_name,
            "enableAutoSubDomain": enable_auto_sub_domain,
            "subDomainSettings": sub_domain_settings,
            "autoSubDomainCreationPatterns": auto_sub_domain_creation_patterns,
            "autoSubDomainIAMRole": auto_sub_domain_iam_role,
        },
    )


async def delete(hub, ctx, app_id: str, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a domain association for an Amplify app.

    Args:
        app_id(str):  The unique id for an Amplify app. .
        domain_name(str):  The name of the domain. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.domain_association.delete(
                ctx, app_id=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.domain_association.delete app_id=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="delete_domain_association",
        op_kwargs={"appId": app_id, "domainName": domain_name},
    )


async def get(hub, ctx, app_id: str, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns the domain information for an Amplify app.

    Args:
        app_id(str):  The unique id for an Amplify app. .
        domain_name(str):  The name of the domain. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.domain_association.get(
                ctx, app_id=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.domain_association.get app_id=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="get_domain_association",
        op_kwargs={"appId": app_id, "domainName": domain_name},
    )


async def list_all(
    hub, ctx, app_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns the domain associations for an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        next_token(str, optional):  A pagination token. Set to null to start listing apps from the start. If non-null, a pagination token is returned in a result. Pass its value in here to list more projects. . Defaults to None.
        max_results(int, optional):  The maximum number of records to list in a single response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.domain_association.list_all(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.domain_association.list_all app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="list_domain_associations",
        op_kwargs={"appId": app_id, "nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    app_id: str,
    domain_name: str,
    sub_domain_settings: List,
    enable_auto_sub_domain: bool = None,
    auto_sub_domain_creation_patterns: List = None,
    auto_sub_domain_iam_role: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new domain association for an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        domain_name(str):  The name of the domain. .
        enable_auto_sub_domain(bool, optional):  Enables the automated creation of subdomains for branches. . Defaults to None.
        sub_domain_settings(List):  Describes the settings for the subdomain. .
        auto_sub_domain_creation_patterns(List, optional):  Sets the branch patterns for automatic subdomain creation. . Defaults to None.
        auto_sub_domain_iam_role(str, optional):  The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.domain_association.update(
                ctx, app_id=value, domain_name=value, sub_domain_settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.domain_association.update app_id=value, domain_name=value, sub_domain_settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="update_domain_association",
        op_kwargs={
            "appId": app_id,
            "domainName": domain_name,
            "enableAutoSubDomain": enable_auto_sub_domain,
            "subDomainSettings": sub_domain_settings,
            "autoSubDomainCreationPatterns": auto_sub_domain_creation_patterns,
            "autoSubDomainIAMRole": auto_sub_domain_iam_role,
        },
    )
