"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    app_id: str,
    branch_name: str,
    description: str = None,
    stage: str = None,
    framework: str = None,
    enable_notification: bool = None,
    enable_auto_build: bool = None,
    environment_variables: Dict = None,
    basic_auth_credentials: str = None,
    enable_basic_auth: bool = None,
    enable_performance_mode: bool = None,
    tags: Dict = None,
    build_spec: str = None,
    ttl: str = None,
    display_name: str = None,
    enable_pull_request_preview: bool = None,
    pull_request_environment_name: str = None,
    backend_environment_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new branch for an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        branch_name(str):  The name for the branch. .
        description(str, optional):  The description for the branch. . Defaults to None.
        stage(str, optional):  Describes the current stage for the branch. . Defaults to None.
        framework(str, optional):  The framework for the branch. . Defaults to None.
        enable_notification(bool, optional):  Enables notifications for the branch. . Defaults to None.
        enable_auto_build(bool, optional):  Enables auto building for the branch. . Defaults to None.
        environment_variables(Dict, optional):  The environment variables for the branch. . Defaults to None.
        basic_auth_credentials(str, optional):  The basic authorization credentials for the branch. . Defaults to None.
        enable_basic_auth(bool, optional):  Enables basic authorization for the branch. . Defaults to None.
        enable_performance_mode(bool, optional): Enables performance mode for the branch. Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. . Defaults to None.
        tags(Dict, optional):  The tag for the branch. . Defaults to None.
        build_spec(str, optional):  The build specification (build spec) for the branch. . Defaults to None.
        ttl(str, optional):  The content Time To Live (TTL) for the website in seconds. . Defaults to None.
        display_name(str, optional):  The display name for a branch. This is used as the default domain prefix. . Defaults to None.
        enable_pull_request_preview(bool, optional):  Enables pull request previews for this branch. . Defaults to None.
        pull_request_environment_name(str, optional):  The Amplify environment name for the pull request. . Defaults to None.
        backend_environment_arn(str, optional):  The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.branch.create(ctx, app_id=value, branch_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.branch.create app_id=value, branch_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="create_branch",
        op_kwargs={
            "appId": app_id,
            "branchName": branch_name,
            "description": description,
            "stage": stage,
            "framework": framework,
            "enableNotification": enable_notification,
            "enableAutoBuild": enable_auto_build,
            "environmentVariables": environment_variables,
            "basicAuthCredentials": basic_auth_credentials,
            "enableBasicAuth": enable_basic_auth,
            "enablePerformanceMode": enable_performance_mode,
            "tags": tags,
            "buildSpec": build_spec,
            "ttl": ttl,
            "displayName": display_name,
            "enablePullRequestPreview": enable_pull_request_preview,
            "pullRequestEnvironmentName": pull_request_environment_name,
            "backendEnvironmentArn": backend_environment_arn,
        },
    )


async def delete(hub, ctx, app_id: str, branch_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a branch for an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        branch_name(str):  The name for the branch. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.branch.delete(ctx, app_id=value, branch_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.branch.delete app_id=value, branch_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="delete_branch",
        op_kwargs={"appId": app_id, "branchName": branch_name},
    )


async def get(hub, ctx, app_id: str, branch_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns a branch for an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        branch_name(str):  The name for the branch. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.branch.get(ctx, app_id=value, branch_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.branch.get app_id=value, branch_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="get_branch",
        op_kwargs={"appId": app_id, "branchName": branch_name},
    )


async def list_all(
    hub, ctx, app_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     Lists the branches of an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        next_token(str, optional):  A pagination token. Set to null to start listing branches from the start. If a non-null pagination token is returned in a result, pass its value in here to list more branches. . Defaults to None.
        max_results(int, optional):  The maximum number of records to list in a single response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.branch.list_all(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.branch.list_all app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="list_branches",
        op_kwargs={"appId": app_id, "nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    app_id: str,
    branch_name: str,
    description: str = None,
    framework: str = None,
    stage: str = None,
    enable_notification: bool = None,
    enable_auto_build: bool = None,
    environment_variables: Dict = None,
    basic_auth_credentials: str = None,
    enable_basic_auth: bool = None,
    enable_performance_mode: bool = None,
    build_spec: str = None,
    ttl: str = None,
    display_name: str = None,
    enable_pull_request_preview: bool = None,
    pull_request_environment_name: str = None,
    backend_environment_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates a branch for an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        branch_name(str):  The name for the branch. .
        description(str, optional):  The description for the branch. . Defaults to None.
        framework(str, optional):  The framework for the branch. . Defaults to None.
        stage(str, optional):  Describes the current stage for the branch. . Defaults to None.
        enable_notification(bool, optional):  Enables notifications for the branch. . Defaults to None.
        enable_auto_build(bool, optional):  Enables auto building for the branch. . Defaults to None.
        environment_variables(Dict, optional):  The environment variables for the branch. . Defaults to None.
        basic_auth_credentials(str, optional):  The basic authorization credentials for the branch. . Defaults to None.
        enable_basic_auth(bool, optional):  Enables basic authorization for the branch. . Defaults to None.
        enable_performance_mode(bool, optional): Enables performance mode for the branch. Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out. . Defaults to None.
        build_spec(str, optional):  The build specification (build spec) for the branch. . Defaults to None.
        ttl(str, optional):  The content Time to Live (TTL) for the website in seconds. . Defaults to None.
        display_name(str, optional):  The display name for a branch. This is used as the default domain prefix. . Defaults to None.
        enable_pull_request_preview(bool, optional):  Enables pull request previews for this branch. . Defaults to None.
        pull_request_environment_name(str, optional):  The Amplify environment name for the pull request. . Defaults to None.
        backend_environment_arn(str, optional):  The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.branch.update(ctx, app_id=value, branch_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.branch.update app_id=value, branch_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="update_branch",
        op_kwargs={
            "appId": app_id,
            "branchName": branch_name,
            "description": description,
            "framework": framework,
            "stage": stage,
            "enableNotification": enable_notification,
            "enableAutoBuild": enable_auto_build,
            "environmentVariables": environment_variables,
            "basicAuthCredentials": basic_auth_credentials,
            "enableBasicAuth": enable_basic_auth,
            "enablePerformanceMode": enable_performance_mode,
            "buildSpec": build_spec,
            "ttl": ttl,
            "displayName": display_name,
            "enablePullRequestPreview": enable_pull_request_preview,
            "pullRequestEnvironmentName": pull_request_environment_name,
            "backendEnvironmentArn": backend_environment_arn,
        },
    )
