"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    app_id: str,
    environment_name: str,
    stack_name: str = None,
    deployment_artifacts: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new backend environment for an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        environment_name(str):  The name for the backend environment. .
        stack_name(str, optional):  The AWS CloudFormation stack name of a backend environment. . Defaults to None.
        deployment_artifacts(str, optional):  The name of deployment artifacts. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.backend_environment.create(
                ctx, app_id=value, environment_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.backend_environment.create app_id=value, environment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="create_backend_environment",
        op_kwargs={
            "appId": app_id,
            "environmentName": environment_name,
            "stackName": stack_name,
            "deploymentArtifacts": deployment_artifacts,
        },
    )


async def delete(hub, ctx, app_id: str, environment_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a backend environment for an Amplify app.

    Args:
        app_id(str):  The unique ID of an Amplify app. .
        environment_name(str):  The name of a backend environment of an Amplify app. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.backend_environment.delete(
                ctx, app_id=value, environment_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.backend_environment.delete app_id=value, environment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="delete_backend_environment",
        op_kwargs={"appId": app_id, "environmentName": environment_name},
    )


async def get(hub, ctx, app_id: str, environment_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns a backend environment for an Amplify app.

    Args:
        app_id(str):  The unique id for an Amplify app. .
        environment_name(str):  The name for the backend environment. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.backend_environment.get(
                ctx, app_id=value, environment_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.backend_environment.get app_id=value, environment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="get_backend_environment",
        op_kwargs={"appId": app_id, "environmentName": environment_name},
    )


async def list_all(
    hub,
    ctx,
    app_id: str,
    environment_name: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Lists the backend environments for an Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        environment_name(str, optional):  The name of the backend environment . Defaults to None.
        next_token(str, optional):  A pagination token. Set to null to start listing backend environments from the start. If a non-null pagination token is returned in a result, pass its value in here to list more backend environments. . Defaults to None.
        max_results(int, optional):  The maximum number of records to list in a single response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.backend_environment.list_all(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.backend_environment.list_all app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="list_backend_environments",
        op_kwargs={
            "appId": app_id,
            "environmentName": environment_name,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
