"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, artifact_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns the artifact info that corresponds to an artifact id.

    Args:
        artifact_id(str):  The unique ID for an artifact. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.artifact.url.get(ctx, artifact_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.artifact.url.get artifact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="get_artifact_url",
        op_kwargs={"artifactId": artifact_id},
    )
