"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    app_id: str,
    branch_name: str,
    job_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of artifacts for a specified app, branch, and job.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        branch_name(str):  The name of a branch that is part of an Amplify app. .
        job_id(str):  The unique ID for a job. .
        next_token(str, optional):  A pagination token. Set to null to start listing artifacts from start. If a non-null pagination token is returned in a result, pass its value in here to list more artifacts. . Defaults to None.
        max_results(int, optional):  The maximum number of records to list in a single response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.artifact.init.list_all(
                ctx, app_id=value, branch_name=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.artifact.init.list_all app_id=value, branch_name=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="list_artifacts",
        op_kwargs={
            "appId": app_id,
            "branchName": branch_name,
            "jobId": job_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
