"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of the existing Amplify apps.

    Args:
        next_token(str, optional):  A pagination token. If non-null, the pagination token is returned in a result. Pass its value in another request to retrieve more entries. . Defaults to None.
        max_results(int, optional):  The maximum number of records to list in a single response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.apps.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.apps.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="list_apps",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )
