"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    description: str = None,
    repository: str = None,
    platform: str = None,
    iam_service_role_arn: str = None,
    oauth_token: str = None,
    access_token: str = None,
    environment_variables: Dict = None,
    enable_branch_auto_build: bool = None,
    enable_branch_auto_deletion: bool = None,
    enable_basic_auth: bool = None,
    basic_auth_credentials: str = None,
    custom_rules: List = None,
    tags: Dict = None,
    build_spec: str = None,
    custom_headers: str = None,
    enable_auto_branch_creation: bool = None,
    auto_branch_creation_patterns: List = None,
    auto_branch_creation_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a new Amplify app.

    Args:
        name(str):  The name for an Amplify app. .
        description(str, optional):  The description for an Amplify app. . Defaults to None.
        repository(str, optional):  The repository for an Amplify app. . Defaults to None.
        platform(str, optional):  The platform or framework for an Amplify app. . Defaults to None.
        iam_service_role_arn(str, optional):  The AWS Identity and Access Management (IAM) service role for an Amplify app. . Defaults to None.
        oauth_token(str, optional):  The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored. . Defaults to None.
        access_token(str, optional):  The personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored. . Defaults to None.
        environment_variables(Dict, optional):  The environment variables map for an Amplify app. . Defaults to None.
        enable_branch_auto_build(bool, optional):  Enables the auto building of branches for an Amplify app. . Defaults to None.
        enable_branch_auto_deletion(bool, optional):  Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. . Defaults to None.
        enable_basic_auth(bool, optional):  Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app. . Defaults to None.
        basic_auth_credentials(str, optional):  The credentials for basic authorization for an Amplify app. . Defaults to None.
        custom_rules(List, optional):  The custom rewrite and redirect rules for an Amplify app. . Defaults to None.
        tags(Dict, optional):  The tag for an Amplify app. . Defaults to None.
        build_spec(str, optional):  The build specification (build spec) for an Amplify app. . Defaults to None.
        custom_headers(str, optional): The custom HTTP headers for an Amplify app. Defaults to None.
        enable_auto_branch_creation(bool, optional):  Enables automated branch creation for an Amplify app. . Defaults to None.
        auto_branch_creation_patterns(List, optional):  The automated branch creation glob patterns for an Amplify app. . Defaults to None.
        auto_branch_creation_config(Dict, optional):  The automated branch creation configuration for an Amplify app. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.app.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.app.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="create_app",
        op_kwargs={
            "name": name,
            "description": description,
            "repository": repository,
            "platform": platform,
            "iamServiceRoleArn": iam_service_role_arn,
            "oauthToken": oauth_token,
            "accessToken": access_token,
            "environmentVariables": environment_variables,
            "enableBranchAutoBuild": enable_branch_auto_build,
            "enableBranchAutoDeletion": enable_branch_auto_deletion,
            "enableBasicAuth": enable_basic_auth,
            "basicAuthCredentials": basic_auth_credentials,
            "customRules": custom_rules,
            "tags": tags,
            "buildSpec": build_spec,
            "customHeaders": custom_headers,
            "enableAutoBranchCreation": enable_auto_branch_creation,
            "autoBranchCreationPatterns": auto_branch_creation_patterns,
            "autoBranchCreationConfig": auto_branch_creation_config,
        },
    )


async def delete(hub, ctx, app_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes an existing Amplify app specified by an app ID.

    Args:
        app_id(str):  The unique ID for an Amplify app. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.app.delete(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.app.delete app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="amplify", operation="delete_app", op_kwargs={"appId": app_id}
    )


async def get(hub, ctx, app_id: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns an existing Amplify app by appID.

    Args:
        app_id(str):  The unique ID for an Amplify app. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.app.get(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.app.get app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="amplify", operation="get_app", op_kwargs={"appId": app_id}
    )


async def update(
    hub,
    ctx,
    app_id: str,
    name: str = None,
    description: str = None,
    platform: str = None,
    iam_service_role_arn: str = None,
    environment_variables: Dict = None,
    enable_branch_auto_build: bool = None,
    enable_branch_auto_deletion: bool = None,
    enable_basic_auth: bool = None,
    basic_auth_credentials: str = None,
    custom_rules: List = None,
    build_spec: str = None,
    custom_headers: str = None,
    enable_auto_branch_creation: bool = None,
    auto_branch_creation_patterns: List = None,
    auto_branch_creation_config: Dict = None,
    repository: str = None,
    oauth_token: str = None,
    access_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates an existing Amplify app.

    Args:
        app_id(str):  The unique ID for an Amplify app. .
        name(str, optional):  The name for an Amplify app. . Defaults to None.
        description(str, optional):  The description for an Amplify app. . Defaults to None.
        platform(str, optional):  The platform for an Amplify app. . Defaults to None.
        iam_service_role_arn(str, optional):  The AWS Identity and Access Management (IAM) service role for an Amplify app. . Defaults to None.
        environment_variables(Dict, optional):  The environment variables for an Amplify app. . Defaults to None.
        enable_branch_auto_build(bool, optional):  Enables branch auto-building for an Amplify app. . Defaults to None.
        enable_branch_auto_deletion(bool, optional):  Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository. . Defaults to None.
        enable_basic_auth(bool, optional):  Enables basic authorization for an Amplify app. . Defaults to None.
        basic_auth_credentials(str, optional):  The basic authorization credentials for an Amplify app. . Defaults to None.
        custom_rules(List, optional):  The custom redirect and rewrite rules for an Amplify app. . Defaults to None.
        build_spec(str, optional):  The build specification (build spec) for an Amplify app. . Defaults to None.
        custom_headers(str, optional): The custom HTTP headers for an Amplify app. Defaults to None.
        enable_auto_branch_creation(bool, optional):  Enables automated branch creation for an Amplify app. . Defaults to None.
        auto_branch_creation_patterns(List, optional):  Describes the automated branch creation glob patterns for an Amplify app. . Defaults to None.
        auto_branch_creation_config(Dict, optional):  The automated branch creation configuration for an Amplify app. . Defaults to None.
        repository(str, optional):  The name of the repository for an Amplify app . Defaults to None.
        oauth_token(str, optional):  The OAuth token for a third-party source control system for an Amplify app. The token is used to create a webhook and a read-only deploy key. The OAuth token is not stored. . Defaults to None.
        access_token(str, optional):  The personal access token for a third-party source control system for an Amplify app. The token is used to create webhook and a read-only deploy key. The token is not stored. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.app.update(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.app.update app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="update_app",
        op_kwargs={
            "appId": app_id,
            "name": name,
            "description": description,
            "platform": platform,
            "iamServiceRoleArn": iam_service_role_arn,
            "environmentVariables": environment_variables,
            "enableBranchAutoBuild": enable_branch_auto_build,
            "enableBranchAutoDeletion": enable_branch_auto_deletion,
            "enableBasicAuth": enable_basic_auth,
            "basicAuthCredentials": basic_auth_credentials,
            "customRules": custom_rules,
            "buildSpec": build_spec,
            "customHeaders": custom_headers,
            "enableAutoBranchCreation": enable_auto_branch_creation,
            "autoBranchCreationPatterns": auto_branch_creation_patterns,
            "autoBranchCreationConfig": auto_branch_creation_config,
            "repository": repository,
            "oauthToken": oauth_token,
            "accessToken": access_token,
        },
    )
