"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def generate(
    hub,
    ctx,
    domain_name: str,
    app_id: str,
    start_time: str = None,
    end_time: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns the website access logs for a specific time range using a presigned URL.

    Args:
        start_time(str, optional):  The time at which the logs should start. The time range specified is inclusive of the start time. . Defaults to None.
        end_time(str, optional):  The time at which the logs should end. The time range specified is inclusive of the end time. . Defaults to None.
        domain_name(str):  The name of the domain. .
        app_id(str):  The unique ID for an Amplify app. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplify.access_log.generate(
                ctx, domain_name=value, app_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplify.access_log.generate domain_name=value, app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplify",
        operation="generate_access_logs",
        op_kwargs={
            "startTime": start_time,
            "endTime": end_time,
            "domainName": domain_name,
            "appId": app_id,
        },
    )
