"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, alias: str = None, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new AMP workspace.

    Args:
        alias(str, optional): An optional user-assigned alias for this workspace. This alias is for user reference and does not need to be unique. Defaults to None.
        client_token(str, optional): Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amp_workspace.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amp_workspace.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amp",
        operation="create_workspace",
        op_kwargs={"alias": alias, "clientToken": client_token},
    )


async def delete(hub, ctx, workspace_id: str, client_token: str = None) -> None:
    r"""
    **Autogenerated function**

    Deletes an AMP workspace.

    Args:
        client_token(str, optional): Optional, unique, case-sensitive, user-provided identifier to ensure the idempotency of the request. Defaults to None.
        workspace_id(str): The ID of the workspace to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amp_workspace.init.delete(ctx, workspace_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amp_workspace.init.delete workspace_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amp",
        operation="delete_workspace",
        op_kwargs={"clientToken": client_token, "workspaceId": workspace_id},
    )


async def describe(hub, ctx, workspace_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing AMP workspace.

    Args:
        workspace_id(str): The ID of the workspace to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amp_workspace.init.describe(ctx, workspace_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amp_workspace.init.describe workspace_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amp",
        operation="describe_workspace",
        op_kwargs={"workspaceId": workspace_id},
    )


async def list_all(
    hub, ctx, alias: str = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all AMP workspaces, including workspaces being created or deleted.

    Args:
        alias(str, optional): Optional filter for workspace alias. Only the workspaces with aliases that begin with this value will be returned. Defaults to None.
        max_results(int, optional): Maximum results to return in response (default=100, maximum=1000). Defaults to None.
        next_token(str, optional): Pagination token to request the next page in a paginated list. This token is obtained from the output of the previous ListWorkspaces request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amp_workspace.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amp_workspace.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amp",
        operation="list_workspaces",
        op_kwargs={"alias": alias, "maxResults": max_results, "nextToken": next_token},
    )
