"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    user_id: str,
    first_name: str = None,
    last_name: str = None,
    email: str = None,
    client_request_token: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a user.

    Args:
        user_id(str): The ARN for the user.
        first_name(str, optional): The first name for the user. Defaults to None.
        last_name(str, optional): The last name for the user. Defaults to None.
        email(str, optional): The email address for the user. Defaults to None.
        client_request_token(str, optional): A unique, user-specified identifier for this request that ensures idempotency. . Defaults to None.
        tags(List, optional): The tags for the user. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.user.create(ctx, user_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.user.create user_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="create_user",
        op_kwargs={
            "UserId": user_id,
            "FirstName": first_name,
            "LastName": last_name,
            "Email": email,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, enrollment_id: str, user_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified user by user ARN and enrollment ARN.

    Args:
        user_arn(str, optional): The ARN of the user to delete in the organization. Required. Defaults to None.
        enrollment_id(str): The ARN of the user's enrollment in the organization. Required.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.user.delete(ctx, enrollment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.user.delete enrollment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="delete_user",
        op_kwargs={"UserArn": user_arn, "EnrollmentId": enrollment_id},
    )


async def search(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    filters: List = None,
    sort_criteria: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches users and lists the ones that meet a set of filter and sort criteria.

    Args:
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. Required. Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. Required. Defaults to None.
        filters(List, optional): The filters to use for listing a specific set of users. Required. Supported filter keys are UserId, FirstName, LastName, Email, and EnrollmentStatus. Defaults to None.
        sort_criteria(List, optional): The sort order to use in listing the filtered set of users. Required. Supported sort keys are UserId, FirstName, LastName, Email, and EnrollmentStatus. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.user.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.user.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="search_users",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
            "SortCriteria": sort_criteria,
        },
    )
