"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def forget(hub, ctx, room_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Forgets smart home appliances associated to a room.

    Args:
        room_arn(str): The room that the appliances are associated with.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.smart_home_appliance.init.forget(
                ctx, room_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.smart_home_appliance.init.forget room_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="forget_smart_home_appliances",
        op_kwargs={"RoomArn": room_arn},
    )


async def list_all(
    hub, ctx, room_arn: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the smart home appliances associated with a room.

    Args:
        room_arn(str): The room that the appliances are associated with.
        max_results(int, optional): The maximum number of appliances to be returned, per paginated calls. Defaults to None.
        next_token(str, optional): The tokens used for pagination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.smart_home_appliance.init.list_all(
                ctx, room_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.smart_home_appliance.init.list_all room_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="list_smart_home_appliances",
        op_kwargs={
            "RoomArn": room_arn,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
