"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, room_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Initiates the discovery of any smart home appliances associated with the room.

    Args:
        room_arn(str): The room where smart home appliance discovery was initiated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.smart_home_appliance.discovery.start(
                ctx, room_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.smart_home_appliance.discovery.start room_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="start_smart_home_appliance_discovery",
        op_kwargs={"RoomArn": room_arn},
    )
