"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, skill_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Makes a private skill available for enrolled users to enable on their devices.

    Args:
        skill_id(str): The private skill ID you want to make available to enrolled users.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.with_.user.associate(ctx, skill_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.with_.user.associate skill_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="associate_skill_with_users",
        op_kwargs={"SkillId": skill_id},
    )
