"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, skill_id: str, skill_group_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Associates a skill with a skill group.

    Args:
        skill_group_arn(str, optional): The ARN of the skill group to associate the skill to. Required. Defaults to None.
        skill_id(str): The unique identifier of the skill.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.with_.skill_group.associate(
                ctx, skill_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.with_.skill_group.associate skill_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="associate_skill_with_skill_group",
        op_kwargs={"SkillGroupArn": skill_group_arn, "SkillId": skill_id},
    )
