"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, category_id: int, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all skills in the Alexa skill store by category.

    Args:
        category_id(int): The category ID for which the skills are being retrieved from the skill store.
        next_token(str, optional): The tokens used for pagination. Defaults to None.
        max_results(int, optional): The maximum number of skills returned per paginated calls. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.store.skill_by_category.list(
                ctx, category_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.store.skill_by_category.list category_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="list_skills_store_skills_by_category",
        op_kwargs={
            "CategoryId": category_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
