"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all categories in the Alexa skill store.

    Args:
        next_token(str, optional): The tokens used for pagination. Defaults to None.
        max_results(int, optional): The maximum number of categories returned, per paginated calls. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.store.category.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.store.category.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="list_skills_store_categories",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
