"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def approve(hub, ctx, skill_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates a skill with the organization under the customer's AWS account. If a skill is private, the user implicitly accepts access to this skill during enablement.

    Args:
        skill_id(str): The unique identifier of the skill.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.init.approve(ctx, skill_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.init.approve skill_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="approve_skill",
        op_kwargs={"SkillId": skill_id},
    )


async def list_all(
    hub,
    ctx,
    skill_group_arn: str = None,
    enablement_type: str = None,
    skill_type: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all enabled skills in a specific skill group.

    Args:
        skill_group_arn(str, optional): The ARN of the skill group for which to list enabled skills. Defaults to None.
        enablement_type(str, optional): Whether the skill is enabled under the user's account. Defaults to None.
        skill_type(str, optional): Whether the skill is publicly available or is a private skill. Defaults to None.
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="list_skills",
        op_kwargs={
            "SkillGroupArn": skill_group_arn,
            "EnablementType": enablement_type,
            "SkillType": skill_type,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def reject(hub, ctx, skill_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a skill from the organization under a user's AWS account. If the skill is a private skill, it moves to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the ApproveSkill API.

    Args:
        skill_id(str): The unique identifier of the skill.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.init.reject(ctx, skill_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.init.reject skill_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="reject_skill",
        op_kwargs={"SkillId": skill_id},
    )
