"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub, ctx, skill_group_arn: str = None, room_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a skill group with a given room. This enables all skills in the associated skill group on all devices in the room.

    Args:
        skill_group_arn(str, optional): The ARN of the skill group to associate with a room. Required. Defaults to None.
        room_arn(str, optional): The ARN of the room with which to associate the skill group. Required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.group.with_room.associate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.group.with_room.associate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="associate_skill_group_with_room",
        op_kwargs={"SkillGroupArn": skill_group_arn, "RoomArn": room_arn},
    )
