"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(
    hub, ctx, skill_group_arn: str = None, room_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in the room.

    Args:
        skill_group_arn(str, optional): The ARN of the skill group to disassociate from a room. Required. Defaults to None.
        room_arn(str, optional): The ARN of the room from which the skill group is to be disassociated. Required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.group.from_room.disassociate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.group.from_room.disassociate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="disassociate_skill_group_from_room",
        op_kwargs={"SkillGroupArn": skill_group_arn, "RoomArn": room_arn},
    )
