"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx, skill_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.

    Args:
        skill_id(str):  The private skill ID you want to make unavailable for enrolled users.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.from_.user.disassociate(
                ctx, skill_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.from_.user.disassociate skill_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="disassociate_skill_from_users",
        op_kwargs={"SkillId": skill_id},
    )
