"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx, skill_id: str, skill_group_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a skill from a skill group.

    Args:
        skill_group_arn(str, optional): The unique identifier of a skill. Required. Defaults to None.
        skill_id(str): The ARN of a skill group to associate to a skill.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.from_.skill_group.disassociate(
                ctx, skill_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.from_.skill_group.disassociate skill_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="disassociate_skill_from_skill_group",
        op_kwargs={"SkillGroupArn": skill_group_arn, "SkillId": skill_id},
    )
