"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, skill_id: str, room_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Unlinks a third-party account from a skill.

    Args:
        skill_id(str): The unique identifier of a skill.
        room_arn(str, optional): The room that the skill is authorized for. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.authorization.delete(ctx, skill_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.authorization.delete skill_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="delete_skill_authorization",
        op_kwargs={"SkillId": skill_id, "RoomArn": room_arn},
    )


async def put(
    hub, ctx, authorization_result: Dict, skill_id: str, room_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Links a user's account to a third-party skill provider. If this API operation is called by an assumed IAM role, the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the IAM role.

    Args:
        authorization_result(Dict): The authorization result specific to OAUTH code grant output. "Code” must be populated in the AuthorizationResult map to establish the authorization.
        skill_id(str): The unique identifier of a skill.
        room_arn(str, optional): The room that the skill is authorized for. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.skill.authorization.put(
                ctx, authorization_result=value, skill_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.skill.authorization.put authorization_result=value, skill_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="put_skill_authorization",
        op_kwargs={
            "AuthorizationResult": authorization_result,
            "SkillId": skill_id,
            "RoomArn": room_arn,
        },
    )
