"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(
    hub, ctx, skill_id: str, parameter_key: str, room_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes room skill parameter details by room, skill, and parameter key ID.

    Args:
        room_arn(str, optional): The ARN of the room from which to remove the room skill parameter details. Defaults to None.
        skill_id(str): The ID of the skill from which to remove the room skill parameter details.
        parameter_key(str): The room skill parameter key for which to remove details.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.room.skill_parameter.delete(
                ctx, skill_id=value, parameter_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.room.skill_parameter.delete skill_id=value, parameter_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="delete_room_skill_parameter",
        op_kwargs={
            "RoomArn": room_arn,
            "SkillId": skill_id,
            "ParameterKey": parameter_key,
        },
    )


async def get(
    hub, ctx, skill_id: str, parameter_key: str, room_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets room skill parameter details by room, skill, and parameter key ARN.

    Args:
        room_arn(str, optional): The ARN of the room from which to get the room skill parameter details. . Defaults to None.
        skill_id(str): The ARN of the skill from which to get the room skill parameter details. Required.
        parameter_key(str): The room skill parameter key for which to get details. Required.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.room.skill_parameter.get(
                ctx, skill_id=value, parameter_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.room.skill_parameter.get skill_id=value, parameter_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="get_room_skill_parameter",
        op_kwargs={
            "RoomArn": room_arn,
            "SkillId": skill_id,
            "ParameterKey": parameter_key,
        },
    )


async def put(
    hub, ctx, skill_id: str, room_skill_parameter: Dict, room_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill parameter.

    Args:
        room_arn(str, optional): The ARN of the room associated with the room skill parameter. Required. Defaults to None.
        skill_id(str): The ARN of the skill associated with the room skill parameter. Required.
        room_skill_parameter(Dict): The updated room skill parameter. Required.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.room.skill_parameter.put(
                ctx, skill_id=value, room_skill_parameter=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.room.skill_parameter.put skill_id=value, room_skill_parameter=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="put_room_skill_parameter",
        op_kwargs={
            "RoomArn": room_arn,
            "SkillId": skill_id,
            "RoomSkillParameter": room_skill_parameter,
        },
    )
