"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    room_name: str,
    description: str = None,
    profile_arn: str = None,
    provider_calendar_id: str = None,
    client_request_token: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a room with the specified details.

    Args:
        room_name(str): The name for the room.
        description(str, optional): The description for the room. Defaults to None.
        profile_arn(str, optional): The profile ARN for the room. This is required. Defaults to None.
        provider_calendar_id(str, optional): The calendar ARN for the room. Defaults to None.
        client_request_token(str, optional): A unique, user-specified identifier for this request that ensures idempotency. . Defaults to None.
        tags(List, optional): The tags for the room. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.room.init.create(ctx, room_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.room.init.create room_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="create_room",
        op_kwargs={
            "RoomName": room_name,
            "Description": description,
            "ProfileArn": profile_arn,
            "ProviderCalendarId": provider_calendar_id,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, room_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a room by the room ARN.

    Args:
        room_arn(str, optional): The ARN of the room to delete. Required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.room.init.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.room.init.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="delete_room",
        op_kwargs={"RoomArn": room_arn},
    )


async def get(hub, ctx, room_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets room details by room ARN.

    Args:
        room_arn(str, optional): The ARN of the room for which to request details. Required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.room.init.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.room.init.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="get_room",
        op_kwargs={"RoomArn": room_arn},
    )


async def resolve(hub, ctx, user_id: str, skill_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Determines the details for the room from which a skill request was invoked. This operation is used by skill developers. To query ResolveRoom from an Alexa skill, the skill ID needs to be authorized. When the skill is using an AWS Lambda function, the skill is automatically authorized when you publish your skill as a private skill to your AWS account. Skills that are hosted using a custom web service must be manually authorized. To get your skill authorized, contact AWS Support with your AWS account ID that queries the ResolveRoom API and skill ID.

    Args:
        user_id(str): The ARN of the user. Required.
        skill_id(str): The ARN of the skill that was requested. Required.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.room.init.resolve(
                ctx, user_id=value, skill_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.room.init.resolve user_id=value, skill_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="resolve_room",
        op_kwargs={"UserId": user_id, "SkillId": skill_id},
    )


async def search(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    filters: List = None,
    sort_criteria: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches rooms and lists the ones that meet a set of filter and sort criteria.

    Args:
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. . Defaults to None.
        filters(List, optional): The filters to use to list a specified set of rooms. The supported filter keys are RoomName and ProfileName. Defaults to None.
        sort_criteria(List, optional): The sort order to use in listing the specified set of rooms. The supported sort keys are RoomName and ProfileName. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.room.init.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.room.init.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="search_rooms",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
            "SortCriteria": sort_criteria,
        },
    )


async def update(
    hub,
    ctx,
    room_arn: str = None,
    room_name: str = None,
    description: str = None,
    provider_calendar_id: str = None,
    profile_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates room details by room ARN.

    Args:
        room_arn(str, optional): The ARN of the room to update. . Defaults to None.
        room_name(str, optional): The updated name for the room. Defaults to None.
        description(str, optional): The updated description for the room. Defaults to None.
        provider_calendar_id(str, optional): The updated provider calendar ARN for the room. Defaults to None.
        profile_arn(str, optional): The updated profile ARN for the room. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.room.init.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.room.init.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="update_room",
        op_kwargs={
            "RoomArn": room_arn,
            "RoomName": room_name,
            "Description": description,
            "ProviderCalendarId": provider_calendar_id,
            "ProfileArn": profile_arn,
        },
    )
