"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, arn: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds metadata tags to a specified resource.

    Args:
        arn(str): The ARN of the resource to which to add metadata tags. Required. .
        tags(List): The tags to be added to the specified resource. Do not provide system tags. Required. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.resource.tag(ctx, arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.resource.tag arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="tag_resource",
        op_kwargs={"Arn": arn, "Tags": tags},
    )


async def untag(hub, ctx, arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes metadata tags from a specified resource.

    Args:
        arn(str): The ARN of the resource from which to remove metadata tags. Required. .
        tag_keys(List): The tags to be removed from the specified resource. Do not provide system tags. Required. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.resource.untag(ctx, arn=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.resource.untag arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="untag_resource",
        op_kwargs={"Arn": arn, "TagKeys": tag_keys},
    )
