"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    profile_name: str,
    timezone: str,
    address: str,
    distance_unit: str,
    temperature_unit: str,
    wake_word: str,
    locale: str = None,
    client_request_token: str = None,
    setup_mode_disabled: bool = None,
    max_volume_limit: int = None,
    pstn_enabled: bool = None,
    data_retention_opt_in: bool = None,
    meeting_room_configuration: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new room profile with the specified details.

    Args:
        profile_name(str): The name of a room profile.
        timezone(str): The time zone used by a room profile.
        address(str): The valid address for the room.
        distance_unit(str): The distance unit to be used by devices in the profile.
        temperature_unit(str): The temperature unit to be used by devices in the profile.
        wake_word(str): A wake word for Alexa, Echo, Amazon, or a computer.
        locale(str, optional): The locale of the room profile. (This is currently only available to a limited preview audience.). Defaults to None.
        client_request_token(str, optional): The user-specified token that is used during the creation of a profile. Defaults to None.
        setup_mode_disabled(bool, optional): Whether room profile setup is enabled. Defaults to None.
        max_volume_limit(int, optional): The maximum volume limit for a room profile. Defaults to None.
        pstn_enabled(bool, optional): Whether PSTN calling is enabled. Defaults to None.
        data_retention_opt_in(bool, optional): Whether data retention of the profile is enabled. Defaults to None.
        meeting_room_configuration(Dict, optional): The meeting room settings of a room profile. Defaults to None.
        tags(List, optional): The tags for the profile. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.profile.create(
                ctx,
                profile_name=value,
                timezone=value,
                address=value,
                distance_unit=value,
                temperature_unit=value,
                wake_word=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.profile.create profile_name=value, timezone=value, address=value, distance_unit=value, temperature_unit=value, wake_word=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="create_profile",
        op_kwargs={
            "ProfileName": profile_name,
            "Timezone": timezone,
            "Address": address,
            "DistanceUnit": distance_unit,
            "TemperatureUnit": temperature_unit,
            "WakeWord": wake_word,
            "Locale": locale,
            "ClientRequestToken": client_request_token,
            "SetupModeDisabled": setup_mode_disabled,
            "MaxVolumeLimit": max_volume_limit,
            "PSTNEnabled": pstn_enabled,
            "DataRetentionOptIn": data_retention_opt_in,
            "MeetingRoomConfiguration": meeting_room_configuration,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, profile_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a room profile by the profile ARN.

    Args:
        profile_arn(str, optional): The ARN of the room profile to delete. Required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.profile.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.profile.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="delete_profile",
        op_kwargs={"ProfileArn": profile_arn},
    )


async def get(hub, ctx, profile_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the details of a room profile by profile ARN.

    Args:
        profile_arn(str, optional): The ARN of the room profile for which to request details. Required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.profile.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.profile.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="get_profile",
        op_kwargs={"ProfileArn": profile_arn},
    )


async def search(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    filters: List = None,
    sort_criteria: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches room profiles and lists the ones that meet a set of filter criteria.

    Args:
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. Defaults to None.
        filters(List, optional): The filters to use to list a specified set of room profiles. Supported filter keys are ProfileName and Address. Required. . Defaults to None.
        sort_criteria(List, optional): The sort order to use in listing the specified set of room profiles. Supported sort keys are ProfileName and Address. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.profile.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.profile.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="search_profiles",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
            "SortCriteria": sort_criteria,
        },
    )


async def update(
    hub,
    ctx,
    profile_arn: str = None,
    profile_name: str = None,
    is_default: bool = None,
    timezone: str = None,
    address: str = None,
    distance_unit: str = None,
    temperature_unit: str = None,
    wake_word: str = None,
    locale: str = None,
    setup_mode_disabled: bool = None,
    max_volume_limit: int = None,
    pstn_enabled: bool = None,
    data_retention_opt_in: bool = None,
    meeting_room_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing room profile by room profile ARN.

    Args:
        profile_arn(str, optional): The ARN of the room profile to update. Required. Defaults to None.
        profile_name(str, optional): The updated name for the room profile. Defaults to None.
        is_default(bool, optional): Sets the profile as default if selected. If this is missing, no update is done to the default status. Defaults to None.
        timezone(str, optional): The updated timezone for the room profile. Defaults to None.
        address(str, optional): The updated address for the room profile. Defaults to None.
        distance_unit(str, optional): The updated distance unit for the room profile. Defaults to None.
        temperature_unit(str, optional): The updated temperature unit for the room profile. Defaults to None.
        wake_word(str, optional): The updated wake word for the room profile. Defaults to None.
        locale(str, optional): The updated locale for the room profile. (This is currently only available to a limited preview audience.). Defaults to None.
        setup_mode_disabled(bool, optional): Whether the setup mode of the profile is enabled. Defaults to None.
        max_volume_limit(int, optional): The updated maximum volume limit for the room profile. Defaults to None.
        pstn_enabled(bool, optional): Whether the PSTN setting of the room profile is enabled. Defaults to None.
        data_retention_opt_in(bool, optional): Whether data retention of the profile is enabled. Defaults to None.
        meeting_room_configuration(Dict, optional): The updated meeting room settings of a room profile. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.profile.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.profile.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="update_profile",
        op_kwargs={
            "ProfileArn": profile_arn,
            "ProfileName": profile_name,
            "IsDefault": is_default,
            "Timezone": timezone,
            "Address": address,
            "DistanceUnit": distance_unit,
            "TemperatureUnit": temperature_unit,
            "WakeWord": wake_word,
            "Locale": locale,
            "SetupModeDisabled": setup_mode_disabled,
            "MaxVolumeLimit": max_volume_limit,
            "PSTNEnabled": pstn_enabled,
            "DataRetentionOptIn": data_retention_opt_in,
            "MeetingRoomConfiguration": meeting_room_configuration,
        },
    )
