"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    network_profile_name: str,
    ssid: str,
    security_type: str,
    client_request_token: str,
    description: str = None,
    eap_method: str = None,
    current_password: str = None,
    next_password: str = None,
    certificate_authority_arn: str = None,
    trust_anchors: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a network profile with the specified details.

    Args:
        network_profile_name(str): The name of the network profile associated with a device.
        description(str, optional): Detailed information about a device's network profile. Defaults to None.
        ssid(str): The SSID of the Wi-Fi network.
        security_type(str): The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.
        eap_method(str, optional): The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported. Defaults to None.
        current_password(str, optional): The current password of the Wi-Fi network. Defaults to None.
        next_password(str, optional): The next, or subsequent, password of the Wi-Fi network. This password is asynchronously transmitted to the device and is used when the password of the network changes to NextPassword. . Defaults to None.
        certificate_authority_arn(str, optional): The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to issue certificates to the devices. . Defaults to None.
        trust_anchors(List, optional): The root certificates of your authentication server that is installed on your devices and used to trust your authentication server during EAP negotiation. . Defaults to None.
        client_request_token(str): A unique, user-specified identifier for the request that ensures idempotency.
        tags(List, optional): The tags to be added to the specified resource. Do not provide system tags. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.network_profile.create(
                ctx,
                network_profile_name=value,
                ssid=value,
                security_type=value,
                client_request_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.network_profile.create network_profile_name=value, ssid=value, security_type=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="create_network_profile",
        op_kwargs={
            "NetworkProfileName": network_profile_name,
            "Description": description,
            "Ssid": ssid,
            "SecurityType": security_type,
            "EapMethod": eap_method,
            "CurrentPassword": current_password,
            "NextPassword": next_password,
            "CertificateAuthorityArn": certificate_authority_arn,
            "TrustAnchors": trust_anchors,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, network_profile_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a network profile by the network profile ARN.

    Args:
        network_profile_arn(str): The ARN of the network profile associated with a device.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.network_profile.delete(
                ctx, network_profile_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.network_profile.delete network_profile_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="delete_network_profile",
        op_kwargs={"NetworkProfileArn": network_profile_arn},
    )


async def get(hub, ctx, network_profile_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the network profile details by the network profile ARN.

    Args:
        network_profile_arn(str): The ARN of the network profile associated with a device.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.network_profile.get(
                ctx, network_profile_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.network_profile.get network_profile_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="get_network_profile",
        op_kwargs={"NetworkProfileArn": network_profile_arn},
    )


async def search(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    filters: List = None,
    sort_criteria: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches network profiles and lists the ones that meet a set of filter and sort criteria.

    Args:
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. . Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. . Defaults to None.
        filters(List, optional): The filters to use to list a specified set of network profiles. Valid filters are NetworkProfileName, Ssid, and SecurityType. Defaults to None.
        sort_criteria(List, optional): The sort order to use to list the specified set of network profiles. Valid sort criteria includes NetworkProfileName, Ssid, and SecurityType. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.network_profile.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.network_profile.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="search_network_profiles",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
            "SortCriteria": sort_criteria,
        },
    )


async def update(
    hub,
    ctx,
    network_profile_arn: str,
    network_profile_name: str = None,
    description: str = None,
    current_password: str = None,
    next_password: str = None,
    certificate_authority_arn: str = None,
    trust_anchors: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a network profile by the network profile ARN.

    Args:
        network_profile_arn(str): The ARN of the network profile associated with a device.
        network_profile_name(str, optional): The name of the network profile associated with a device. Defaults to None.
        description(str, optional): Detailed information about a device's network profile. Defaults to None.
        current_password(str, optional): The current password of the Wi-Fi network. Defaults to None.
        next_password(str, optional): The next, or subsequent, password of the Wi-Fi network. This password is asynchronously transmitted to the device and is used when the password of the network changes to NextPassword. . Defaults to None.
        certificate_authority_arn(str, optional): The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to issue certificates to the devices. . Defaults to None.
        trust_anchors(List, optional): The root certificate(s) of your authentication server that will be installed on your devices and used to trust your authentication server during EAP negotiation. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.network_profile.update(
                ctx, network_profile_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.network_profile.update network_profile_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="update_network_profile",
        op_kwargs={
            "NetworkProfileArn": network_profile_arn,
            "NetworkProfileName": network_profile_name,
            "Description": description,
            "CurrentPassword": current_password,
            "NextPassword": next_password,
            "CertificateAuthorityArn": certificate_authority_arn,
            "TrustAnchors": trust_anchors,
        },
    )
