"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def revoke(hub, ctx, user_arn: str = None, enrollment_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Revokes an invitation and invalidates the enrollment URL.

    Args:
        user_arn(str, optional): The ARN of the user for whom to revoke an enrollment invitation. Required. Defaults to None.
        enrollment_id(str, optional): The ARN of the enrollment invitation to revoke. Required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.invitation.init.revoke(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.invitation.init.revoke
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="revoke_invitation",
        op_kwargs={"UserArn": user_arn, "EnrollmentId": enrollment_id},
    )


async def send(hub, ctx, user_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Sends an enrollment invitation email with a URL to a user. The URL is valid for 30 days or until you call this operation again, whichever comes first.

    Args:
        user_arn(str, optional): The ARN of the user to whom to send an invitation. Required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.invitation.init.send(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.invitation.init.send
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="send_invitation",
        op_kwargs={"UserArn": user_arn},
    )
