"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the configured values for the user enrollment invitation email template.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.invitation.configuration.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.invitation.configuration.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="get_invitation_configuration",
        op_kwargs={},
    )


async def put(
    hub,
    ctx,
    organization_name: str,
    contact_email: str = None,
    private_skill_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Configures the email template for the user enrollment invitation with the specified attributes.

    Args:
        organization_name(str): The name of the organization sending the enrollment invite to a user.
        contact_email(str, optional): The email ID of the organization or individual contact that the enrolled user can use. . Defaults to None.
        private_skill_ids(List, optional): The list of private skill IDs that you want to recommend to the user to enable in the invitation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.invitation.configuration.put(
                ctx, organization_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.invitation.configuration.put organization_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="put_invitation_configuration",
        op_kwargs={
            "OrganizationName": organization_name,
            "ContactEmail": contact_email,
            "PrivateSkillIds": private_skill_ids,
        },
    )
