"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, gateway_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the details of a gateway.

    Args:
        gateway_arn(str): The ARN of the gateway to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.gateway.init.get(ctx, gateway_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.gateway.init.get gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="get_gateway",
        op_kwargs={"GatewayArn": gateway_arn},
    )


async def list_all(
    hub,
    ctx,
    gateway_group_arn: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that gateway group ARN.

    Args:
        gateway_group_arn(str, optional): The gateway group ARN for which to list gateways. Defaults to None.
        next_token(str, optional): The token used to paginate though multiple pages of gateway summaries. Defaults to None.
        max_results(int, optional): The maximum number of gateway summaries to return. The default is 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.gateway.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.gateway.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="list_gateways",
        op_kwargs={
            "GatewayGroupArn": gateway_group_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    gateway_arn: str,
    name: str = None,
    description: str = None,
    software_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left unmodified.

    Args:
        gateway_arn(str): The ARN of the gateway to update.
        name(str, optional): The updated name of the gateway. Defaults to None.
        description(str, optional): The updated description of the gateway. Defaults to None.
        software_version(str, optional): The updated software version of the gateway. The gateway automatically updates its software version during normal operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.gateway.init.update(ctx, gateway_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.gateway.init.update gateway_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="update_gateway",
        op_kwargs={
            "GatewayArn": gateway_arn,
            "Name": name,
            "Description": description,
            "SoftwareVersion": software_version,
        },
    )
