"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    client_request_token: str,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a gateway group with the specified details.

    Args:
        name(str): The name of the gateway group.
        description(str, optional): The description of the gateway group. Defaults to None.
        client_request_token(str):  A unique, user-specified identifier for the request that ensures idempotency.
        tags(List, optional): The tags to be added to the specified resource. Do not provide system tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.gateway.group.create(
                ctx, name=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.gateway.group.create name=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="create_gateway_group",
        op_kwargs={
            "Name": name,
            "Description": description,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, gateway_group_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a gateway group.

    Args:
        gateway_group_arn(str): The ARN of the gateway group to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.gateway.group.delete(
                ctx, gateway_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.gateway.group.delete gateway_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="delete_gateway_group",
        op_kwargs={"GatewayGroupArn": gateway_group_arn},
    )


async def get(hub, ctx, gateway_group_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the details of a gateway group.

    Args:
        gateway_group_arn(str): The ARN of the gateway group to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.gateway.group.get(ctx, gateway_group_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.gateway.group.get gateway_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="get_gateway_group",
        op_kwargs={"GatewayGroupArn": gateway_group_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.

    Args:
        next_token(str, optional): The token used to paginate though multiple pages of gateway group summaries. Defaults to None.
        max_results(int, optional): The maximum number of gateway group summaries to return. The default is 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.gateway.group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.gateway.group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="list_gateway_groups",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub, ctx, gateway_group_arn: str, name: str = None, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value is left unmodified.

    Args:
        gateway_group_arn(str): The ARN of the gateway group to update.
        name(str, optional): The updated name of the gateway group. Defaults to None.
        description(str, optional): The updated description of the gateway group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.gateway.group.update(
                ctx, gateway_group_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.gateway.group.update gateway_group_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="update_gateway_group",
        op_kwargs={
            "GatewayGroupArn": gateway_group_arn,
            "Name": name,
            "Description": description,
        },
    )
