"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, device_arn: str = None, room_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Associates a device with a given room. This applies all the settings from the room profile to the device, and all the skills in any skill groups added to that room. This operation requires the device to be online, or else a manual sync is required.

    Args:
        device_arn(str, optional): The ARN of the device to associate to a room. Required. Defaults to None.
        room_arn(str, optional): The ARN of the room with which to associate the device. Required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.device.with_.room.associate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.device.with_.room.associate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="associate_device_with_room",
        op_kwargs={"DeviceArn": device_arn, "RoomArn": room_arn},
    )
