"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, device_arn: str, network_profile_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates a device with the specified network profile.

    Args:
        device_arn(str): The device ARN.
        network_profile_arn(str): The ARN of the network profile to associate with a device.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.device.with_.network_profile.associate(
                ctx, device_arn=value, network_profile_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.device.with_.network_profile.associate device_arn=value, network_profile_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="associate_device_with_network_profile",
        op_kwargs={"DeviceArn": device_arn, "NetworkProfileArn": network_profile_arn},
    )
