"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, device_arn: str, device_usage_type: str) -> Dict:
    r"""
    **Autogenerated function**

    When this action is called for a specified shared device, it allows authorized users to delete the device's entire previous history of voice input data and associated response data. This action can be called once every 24 hours for a specific shared device.

    Args:
        device_arn(str): The ARN of the device.
        device_usage_type(str): The type of usage data to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.device.usage_data.delete(
                ctx, device_arn=value, device_usage_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.device.usage_data.delete device_arn=value, device_usage_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="delete_device_usage_data",
        op_kwargs={"DeviceArn": device_arn, "DeviceUsageType": device_usage_type},
    )
