"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, device_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a device from Alexa For Business.

    Args:
        device_arn(str): The ARN of the device for which to request details.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.device.init.delete(ctx, device_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.device.init.delete device_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="delete_device",
        op_kwargs={"DeviceArn": device_arn},
    )


async def get(hub, ctx, device_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the details of a device by device ARN.

    Args:
        device_arn(str, optional): The ARN of the device for which to request details. Required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.device.init.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.device.init.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="get_device",
        op_kwargs={"DeviceArn": device_arn},
    )


async def search(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    filters: List = None,
    sort_criteria: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches devices and lists the ones that meet a set of filter criteria.

    Args:
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response includes only results beyond the token, up to the value specified by MaxResults. Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. Defaults to None.
        filters(List, optional): The filters to use to list a specified set of devices. Supported filter keys are DeviceName, DeviceStatus, DeviceStatusDetailCode, RoomName, DeviceType, DeviceSerialNumber, UnassociatedOnly, ConnectionStatus (ONLINE and OFFLINE), NetworkProfileName, NetworkProfileArn, Feature, and FailureCode. Defaults to None.
        sort_criteria(List, optional): The sort order to use in listing the specified set of devices. Supported sort keys are DeviceName, DeviceStatus, RoomName, DeviceType, DeviceSerialNumber, ConnectionStatus, NetworkProfileName, NetworkProfileArn, Feature, and FailureCode. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.device.init.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.device.init.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="search_devices",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
            "SortCriteria": sort_criteria,
        },
    )


async def update(hub, ctx, device_arn: str = None, device_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the device name by device ARN.

    Args:
        device_arn(str, optional): The ARN of the device to update. Required. Defaults to None.
        device_name(str, optional): The updated device name. Required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.device.init.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.device.init.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="update_device",
        op_kwargs={"DeviceArn": device_arn, "DeviceName": device_name},
    )
