"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, contact_arn: str, address_book_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates a contact with a given address book.

    Args:
        contact_arn(str): The ARN of the contact to associate with an address book.
        address_book_arn(str): The ARN of the address book with which to associate the contact.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.contact.with_address_book.associate(
                ctx, contact_arn=value, address_book_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.contact.with_address_book.associate contact_arn=value, address_book_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="associate_contact_with_address_book",
        op_kwargs={"ContactArn": contact_arn, "AddressBookArn": address_book_arn},
    )
