"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    first_name: str,
    display_name: str = None,
    last_name: str = None,
    phone_number: str = None,
    phone_numbers: List = None,
    sip_addresses: List = None,
    client_request_token: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a contact with the specified details.

    Args:
        display_name(str, optional): The name of the contact to display on the console. Defaults to None.
        first_name(str): The first name of the contact that is used to call the contact on the device.
        last_name(str, optional): The last name of the contact that is used to call the contact on the device. Defaults to None.
        phone_number(str, optional): The phone number of the contact in E.164 format. The phone number type defaults to WORK. You can specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number type and multiple numbers. Defaults to None.
        phone_numbers(List, optional): The list of phone numbers for the contact. Defaults to None.
        sip_addresses(List, optional): The list of SIP addresses for the contact. Defaults to None.
        client_request_token(str, optional): A unique, user-specified identifier for this request that ensures idempotency. Defaults to None.
        tags(List, optional): The tags to be added to the specified resource. Do not provide system tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.contact.init.create(ctx, first_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.contact.init.create first_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="create_contact",
        op_kwargs={
            "DisplayName": display_name,
            "FirstName": first_name,
            "LastName": last_name,
            "PhoneNumber": phone_number,
            "PhoneNumbers": phone_numbers,
            "SipAddresses": sip_addresses,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, contact_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a contact by the contact ARN.

    Args:
        contact_arn(str): The ARN of the contact to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.contact.init.delete(ctx, contact_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.contact.init.delete contact_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="delete_contact",
        op_kwargs={"ContactArn": contact_arn},
    )


async def get(hub, ctx, contact_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the contact details by the contact ARN.

    Args:
        contact_arn(str): The ARN of the contact for which to request details.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.contact.init.get(ctx, contact_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.contact.init.get contact_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="get_contact",
        op_kwargs={"ContactArn": contact_arn},
    )


async def search(
    hub,
    ctx,
    filters: List = None,
    sort_criteria: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches contacts and lists the ones that meet a set of filter and sort criteria.

    Args:
        filters(List, optional): The filters to use to list a specified set of address books. The supported filter keys are DisplayName, FirstName, LastName, and AddressBookArns. Defaults to None.
        sort_criteria(List, optional): The sort order to use in listing the specified set of contacts. The supported sort keys are DisplayName, FirstName, and LastName. Defaults to None.
        next_token(str, optional): An optional token returned from a prior request. Use this token for pagination of results from this action. If this parameter is specified, the response only includes results beyond the token, up to the value specified by MaxResults. Defaults to None.
        max_results(int, optional): The maximum number of results to include in the response. If more results exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.contact.init.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.contact.init.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="search_contacts",
        op_kwargs={
            "Filters": filters,
            "SortCriteria": sort_criteria,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    contact_arn: str,
    display_name: str = None,
    first_name: str = None,
    last_name: str = None,
    phone_number: str = None,
    phone_numbers: List = None,
    sip_addresses: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the contact details by the contact ARN.

    Args:
        contact_arn(str): The ARN of the contact to update.
        display_name(str, optional): The updated display name of the contact. Defaults to None.
        first_name(str, optional): The updated first name of the contact. Defaults to None.
        last_name(str, optional): The updated last name of the contact. Defaults to None.
        phone_number(str, optional): The updated phone number of the contact. The phone number type defaults to WORK. You can either specify PhoneNumber or PhoneNumbers. We recommend that you use PhoneNumbers, which lets you specify the phone number type and multiple numbers. Defaults to None.
        phone_numbers(List, optional): The list of phone numbers for the contact. Defaults to None.
        sip_addresses(List, optional): The list of SIP addresses for the contact. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.contact.init.update(ctx, contact_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.contact.init.update contact_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="update_contact",
        op_kwargs={
            "ContactArn": contact_arn,
            "DisplayName": display_name,
            "FirstName": first_name,
            "LastName": last_name,
            "PhoneNumber": phone_number,
            "PhoneNumbers": phone_numbers,
            "SipAddresses": sip_addresses,
        },
    )
