"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx, contact_arn: str, address_book_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a contact from a given address book.

    Args:
        contact_arn(str): The ARN of the contact to disassociate from an address book.
        address_book_arn(str): The ARN of the address from which to disassociate the contact.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.contact.from_address_book.disassociate(
                ctx, contact_arn=value, address_book_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.contact.from_address_book.disassociate contact_arn=value, address_book_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="disassociate_contact_from_address_book",
        op_kwargs={"ContactArn": contact_arn, "AddressBookArn": address_book_arn},
    )
