"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    conference_provider_name: str,
    conference_provider_type: str,
    meeting_setting: Dict,
    ip_dial_in: Dict = None,
    pstn_dial_in: Dict = None,
    client_request_token: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a new conference provider under the user's AWS account.

    Args:
        conference_provider_name(str): The name of the conference provider.
        conference_provider_type(str): Represents a type within a list of predefined types.
        ip_dial_in(Dict, optional): The IP endpoint and protocol for calling. Defaults to None.
        pstn_dial_in(Dict, optional): The information for PSTN conferencing. Defaults to None.
        meeting_setting(Dict): The meeting settings for the conference provider.
        client_request_token(str, optional): The request token of the client. Defaults to None.
        tags(List, optional): The tags to be added to the specified resource. Do not provide system tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.conference.provider.create(
                ctx,
                conference_provider_name=value,
                conference_provider_type=value,
                meeting_setting=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.conference.provider.create conference_provider_name=value, conference_provider_type=value, meeting_setting=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="create_conference_provider",
        op_kwargs={
            "ConferenceProviderName": conference_provider_name,
            "ConferenceProviderType": conference_provider_type,
            "IPDialIn": ip_dial_in,
            "PSTNDialIn": pstn_dial_in,
            "MeetingSetting": meeting_setting,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, conference_provider_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a conference provider.

    Args:
        conference_provider_arn(str): The ARN of the conference provider.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.conference.provider.delete(
                ctx, conference_provider_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.conference.provider.delete conference_provider_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="delete_conference_provider",
        op_kwargs={"ConferenceProviderArn": conference_provider_arn},
    )


async def get(hub, ctx, conference_provider_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets details about a specific conference provider.

    Args:
        conference_provider_arn(str): The ARN of the newly created conference provider.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.conference.provider.get(
                ctx, conference_provider_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.conference.provider.get conference_provider_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="get_conference_provider",
        op_kwargs={"ConferenceProviderArn": conference_provider_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists conference providers under a specific AWS account.

    Args:
        next_token(str, optional): The tokens used for pagination. Defaults to None.
        max_results(int, optional): The maximum number of conference providers to be returned, per paginated calls. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.conference.provider.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.conference.provider.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="list_conference_providers",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub,
    ctx,
    conference_provider_arn: str,
    conference_provider_type: str,
    meeting_setting: Dict,
    ip_dial_in: Dict = None,
    pstn_dial_in: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing conference provider's settings.

    Args:
        conference_provider_arn(str): The ARN of the conference provider.
        conference_provider_type(str): The type of the conference provider.
        ip_dial_in(Dict, optional): The IP endpoint and protocol for calling. Defaults to None.
        pstn_dial_in(Dict, optional): The information for PSTN conferencing. Defaults to None.
        meeting_setting(Dict): The meeting settings for the conference provider.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.conference.provider.update(
                ctx,
                conference_provider_arn=value,
                conference_provider_type=value,
                meeting_setting=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.conference.provider.update conference_provider_arn=value, conference_provider_type=value, meeting_setting=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="update_conference_provider",
        op_kwargs={
            "ConferenceProviderArn": conference_provider_arn,
            "ConferenceProviderType": conference_provider_type,
            "IPDialIn": ip_dial_in,
            "PSTNDialIn": pstn_dial_in,
            "MeetingSetting": meeting_setting,
        },
    )
