"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the existing conference preferences.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.conference.preference.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.conference.preference.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="get_conference_preference",
        op_kwargs={},
    )


async def put(hub, ctx, conference_preference: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Sets the conference preferences on a specific conference provider at the account level.

    Args:
        conference_preference(Dict): The conference preference of a specific conference provider.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.conference.preference.put(
                ctx, conference_preference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.conference.preference.put conference_preference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="put_conference_preference",
        op_kwargs={"ConferencePreference": conference_preference},
    )
