"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def register(
    hub,
    ctx,
    client_id: str,
    user_code: str,
    product_id: str,
    amazon_id: str,
    device_serial_number: str = None,
    room_arn: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service (AVS).

    Args:
        client_id(str): The client ID of the OEM used for code-based linking authorization on an AVS device.
        user_code(str): The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device Authorization Request component of the OAuth code-based linking specification.
        product_id(str): The product ID used to identify your AVS device during authorization.
        device_serial_number(str, optional): The key generated by the OEM that uniquely identifies a specified instance of your AVS device. Defaults to None.
        amazon_id(str): The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's Developer Console.
        room_arn(str, optional): The Amazon Resource Name (ARN) of the room with which to associate your AVS device. Defaults to None.
        tags(List, optional): The tags to be added to the specified resource. Do not provide system tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.avs_device.register(
                ctx, client_id=value, user_code=value, product_id=value, amazon_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.avs_device.register client_id=value, user_code=value, product_id=value, amazon_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="register_avs_device",
        op_kwargs={
            "ClientId": client_id,
            "UserCode": user_code,
            "ProductId": product_id,
            "DeviceSerialNumber": device_serial_number,
            "AmazonId": amazon_id,
            "RoomArn": room_arn,
            "Tags": tags,
        },
    )
