"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def send(
    hub,
    ctx,
    room_filters: List,
    content: Dict,
    client_request_token: str,
    time_to_live_in_seconds: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search or filter.

    Args:
        room_filters(List): The filters to use to send an announcement to a specified list of rooms. The supported filter keys are RoomName, ProfileName, RoomArn, and ProfileArn. To send to all rooms, specify an empty RoomFilters list.
        content(Dict): The announcement content. This can contain only one of the three possible announcement types (text, SSML or audio).
        time_to_live_in_seconds(int, optional): The time to live for an announcement. Default is 300. If delivery doesn't occur within this time, the announcement is not delivered. Defaults to None.
        client_request_token(str): The unique, user-specified identifier for the request that ensures idempotency.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.alexaforbusiness.announcement.send(
                ctx, room_filters=value, content=value, client_request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.alexaforbusiness.announcement.send room_filters=value, content=value, client_request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="alexaforbusiness",
        operation="send_announcement",
        op_kwargs={
            "RoomFilters": room_filters,
            "Content": content,
            "TimeToLiveInSeconds": time_to_live_in_seconds,
            "ClientRequestToken": client_request_token,
        },
    )
