"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    certificate_authority_arn: str,
    principal: str,
    actions: List,
    source_account: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Grants one or more permissions on a private CA to the AWS Certificate Manager (ACM) service principal (acm.amazonaws.com). These permissions allow ACM to issue and renew ACM certificates that reside in the same AWS account as the CA. You can list current permissions with the ListPermissions action and revoke them with the DeletePermission action.  About Permissions    If the private CA and the certificates it issues reside in the same account, you can use CreatePermission to grant permissions for ACM to carry out automatic certificate renewals.   For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.   If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see Using a Resource Based Policy with ACM Private CA.

    Args:
        certificate_authority_arn(str): The Amazon Resource Name (ARN) of the CA that grants the permissions. You can find the ARN by calling the ListCertificateAuthorities action. This must have the following form:   arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 . .
        principal(str): The AWS service or identity that receives the permission. At this time, the only valid principal is acm.amazonaws.com.
        source_account(str, optional): The ID of the calling account. Defaults to None.
        actions(List): The actions that the specified AWS service principal can use. These include IssueCertificate, GetCertificate, and ListPermissions.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm_pca.permission.create(
                ctx, certificate_authority_arn=value, principal=value, actions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm_pca.permission.create certificate_authority_arn=value, principal=value, actions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm-pca",
        operation="create_permission",
        op_kwargs={
            "CertificateAuthorityArn": certificate_authority_arn,
            "Principal": principal,
            "SourceAccount": source_account,
            "Actions": actions,
        },
    )


async def delete(
    hub, ctx, certificate_authority_arn: str, principal: str, source_account: str = None
) -> None:
    r"""
    **Autogenerated function**

    Revokes permissions on a private CA granted to the AWS Certificate Manager (ACM) service principal (acm.amazonaws.com).  These permissions allow ACM to issue and renew ACM certificates that reside in the same AWS account as the CA. If you revoke these permissions, ACM will no longer renew the affected certificates automatically. Permissions can be granted with the CreatePermission action and listed with the ListPermissions action.   About Permissions    If the private CA and the certificates it issues reside in the same account, you can use CreatePermission to grant permissions for ACM to carry out automatic certificate renewals.   For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.   If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see Using a Resource Based Policy with ACM Private CA.

    Args:
        certificate_authority_arn(str): The Amazon Resource Number (ARN) of the private CA that issued the permissions. You can find the CA's ARN by calling the ListCertificateAuthorities action. This must have the following form:   arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 . .
        principal(str): The AWS service or identity that will have its CA permissions revoked. At this time, the only valid service principal is acm.amazonaws.com .
        source_account(str, optional): The AWS account that calls this action. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm_pca.permission.delete(
                ctx, certificate_authority_arn=value, principal=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm_pca.permission.delete certificate_authority_arn=value, principal=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm-pca",
        operation="delete_permission",
        op_kwargs={
            "CertificateAuthorityArn": certificate_authority_arn,
            "Principal": principal,
            "SourceAccount": source_account,
        },
    )


async def list_all(
    hub,
    ctx,
    certificate_authority_arn: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List all permissions on a private CA, if any, granted to the AWS Certificate Manager (ACM) service principal (acm.amazonaws.com).  These permissions allow ACM to issue and renew ACM certificates that reside in the same AWS account as the CA.  Permissions can be granted with the CreatePermission action and revoked with the DeletePermission action.  About Permissions    If the private CA and the certificates it issues reside in the same account, you can use CreatePermission to grant permissions for ACM to carry out automatic certificate renewals.   For automatic certificate renewal to succeed, the ACM service principal needs permissions to create, retrieve, and list certificates.   If the private CA and the ACM certificates reside in different accounts, then permissions cannot be used to enable automatic renewals. Instead, the ACM certificate owner must set up a resource-based policy to enable cross-account issuance and renewals. For more information, see Using a Resource Based Policy with ACM Private CA.

    Args:
        certificate_authority_arn(str): The Amazon Resource Number (ARN) of the private CA to inspect. You can find the ARN by calling the ListCertificateAuthorities action. This must be of the form: arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 You can get a private CA's ARN by running the ListCertificateAuthorities action.
        next_token(str, optional): When paginating results, use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of NextToken from the response you just received. Defaults to None.
        max_results(int, optional): When paginating results, use this parameter to specify the maximum number of items to return in the response. If additional items exist beyond the number you specify, the NextToken element is sent in the response. Use this NextToken value in a subsequent request to retrieve additional items. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm_pca.permission.list_all(
                ctx, certificate_authority_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm_pca.permission.list_all certificate_authority_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm-pca",
        operation="list_permissions",
        op_kwargs={
            "CertificateAuthorityArn": certificate_authority_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
