"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, certificate_authority_arn: str, certificate_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a certificate from your private CA or one that has been shared with you. The ARN of the certificate is returned when you call the IssueCertificate action. You must specify both the ARN of your private CA and the ARN of the issued certificate when calling the GetCertificate action. You can retrieve the certificate if it is in the ISSUED state. You can call the CreateCertificateAuthorityAuditReport action to create a report that contains information about all of the certificates issued and revoked by your private CA.

    Args:
        certificate_authority_arn(str): The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority. This must be of the form:   arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 . .
        certificate_arn(str): The ARN of the issued certificate. The ARN contains the certificate serial number and must be in the following form:   arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012/certificate/286535153982981100925020015808220737245  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm_pca.certificate.init.get(
                ctx, certificate_authority_arn=value, certificate_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm_pca.certificate.init.get certificate_authority_arn=value, certificate_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm-pca",
        operation="get_certificate",
        op_kwargs={
            "CertificateAuthorityArn": certificate_authority_arn,
            "CertificateArn": certificate_arn,
        },
    )


async def issue(
    hub,
    ctx,
    certificate_authority_arn: str,
    csr: bytes,
    signing_algorithm: str,
    validity: Dict,
    api_passthrough: Dict = None,
    template_arn: str = None,
    validity_not_before: Dict = None,
    idempotency_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Uses your private certificate authority (CA), or one that has been shared with you, to issue a client certificate. This action returns the Amazon Resource Name (ARN) of the certificate. You can retrieve the certificate by calling the GetCertificate action and specifying the ARN.   You cannot use the ACM ListCertificateAuthorities action to retrieve the ARNs of the certificates that you issue by using ACM Private CA.

    Args:
        api_passthrough(Dict, optional): Specifies X.509 certificate information to be included in the issued certificate. An APIPassthrough or APICSRPassthrough template variant must be selected, or else this parameter is ignored. For more information about using these templates, see Understanding Certificate Templates. If conflicting or duplicate certificate information is supplied during certificate issuance, ACM Private CA applies order of operation rules to determine what information is used. Defaults to None.
        certificate_authority_arn(str): The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority. This must be of the form:  arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012  .
        csr(bytes): The certificate signing request (CSR) for the certificate you want to issue. As an example, you can use the following OpenSSL command to create the CSR and a 2048 bit RSA private key.   openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr  If you have a configuration file, you can then use the following OpenSSL command. The usr_cert block in the configuration file contains your X509 version 3 extensions.   openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr  Note: A CSR must provide either a subject name or a subject alternative name or the request will be rejected. .
        signing_algorithm(str): The name of the algorithm that will be used to sign the certificate to be issued.  This parameter should not be confused with the SigningAlgorithm parameter used to sign a CSR in the CreateCertificateAuthority action.
        template_arn(str, optional): Specifies a custom configuration template to use when issuing a certificate. If this parameter is not provided, ACM Private CA defaults to the EndEntityCertificate/V1 template. For CA certificates, you should choose the shortest path length that meets your needs. The path length is indicated by the PathLenN portion of the ARN, where N is the CA depth. Note: The CA depth configured on a subordinate CA certificate must not exceed the limit set by its parents in the CA hierarchy. For a list of TemplateArn values supported by ACM Private CA, see Understanding Certificate Templates. Defaults to None.
        validity(Dict): Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date for the certificate. Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see Validity in RFC 5280.  This value is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value. The end of the validity period configured on a certificate must not exceed the limit set on its parents in the CA hierarchy.
        validity_not_before(Dict, optional): Information describing the start of the validity period of the certificate. This parameter sets the “Not Before" date for the certificate. By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The ValidityNotBefore parameter can be used to customize the “Not Before” value.  Unlike the Validity parameter, the ValidityNotBefore parameter is optional. The ValidityNotBefore value is expressed as an explicit date and time, using the Validity type value ABSOLUTE. For more information, see Validity in this API reference and Validity in RFC 5280. Defaults to None.
        idempotency_token(str, optional): Alphanumeric string that can be used to distinguish between calls to the IssueCertificate action. Idempotency tokens for IssueCertificate time out after one minute. Therefore, if you call IssueCertificate multiple times with the same idempotency token within one minute, ACM Private CA recognizes that you are requesting only one certificate and will issue only one. If you change the idempotency token for each call, PCA recognizes that you are requesting multiple certificates. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm_pca.certificate.init.issue(
                ctx,
                certificate_authority_arn=value,
                csr=value,
                signing_algorithm=value,
                validity=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm_pca.certificate.init.issue certificate_authority_arn=value, csr=value, signing_algorithm=value, validity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm-pca",
        operation="issue_certificate",
        op_kwargs={
            "ApiPassthrough": api_passthrough,
            "CertificateAuthorityArn": certificate_authority_arn,
            "Csr": csr,
            "SigningAlgorithm": signing_algorithm,
            "TemplateArn": template_arn,
            "Validity": validity,
            "ValidityNotBefore": validity_not_before,
            "IdempotencyToken": idempotency_token,
        },
    )


async def revoke(
    hub,
    ctx,
    certificate_authority_arn: str,
    certificate_serial: str,
    revocation_reason: str,
) -> None:
    r"""
    **Autogenerated function**

    Revokes a certificate that was issued inside ACM Private CA. If you enable a certificate revocation list (CRL) when you create or update your private CA, information about the revoked certificates will be included in the CRL. ACM Private CA writes the CRL to an S3 bucket that you specify. A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason the CRL update fails, ACM Private CA attempts makes further attempts every 15 minutes. With Amazon CloudWatch, you can create alarms for the metrics CRLGenerated and MisconfiguredCRLBucket. For more information, see Supported CloudWatch Metrics.  Both PCA and the IAM principal must have permission to write to the S3 bucket that you specify. If the IAM principal making the call does not have permission to write to the bucket, then an exception is thrown. For more information, see Configure Access to ACM Private CA.  ACM Private CA also writes revocation information to the audit report. For more information, see CreateCertificateAuthorityAuditReport.  You cannot revoke a root CA self-signed certificate.

    Args:
        certificate_authority_arn(str): Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:  arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012  .
        certificate_serial(str): Serial number of the certificate to be revoked. This must be in hexadecimal format. You can retrieve the serial number by calling GetCertificate with the Amazon Resource Name (ARN) of the certificate you want and the ARN of your private CA. The GetCertificate action retrieves the certificate in the PEM format. You can use the following OpenSSL command to list the certificate in text format and copy the hexadecimal serial number.   openssl x509 -in file_path -text -noout  You can also copy the serial number from the console or use the DescribeCertificate action in the AWS Certificate Manager API Reference. .
        revocation_reason(str): Specifies why you revoked the certificate.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm_pca.certificate.init.revoke(
                ctx,
                certificate_authority_arn=value,
                certificate_serial=value,
                revocation_reason=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm_pca.certificate.init.revoke certificate_authority_arn=value, certificate_serial=value, revocation_reason=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm-pca",
        operation="revoke_certificate",
        op_kwargs={
            "CertificateAuthorityArn": certificate_authority_arn,
            "CertificateSerial": certificate_serial,
            "RevocationReason": revocation_reason,
        },
    )
