"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, certificate_authority_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the certificate signing request (CSR) for your private certificate authority (CA). The CSR is created when you call the CreateCertificateAuthority action. Sign the CSR with your ACM Private CA-hosted or on-premises root or subordinate CA. Then import the signed certificate back into ACM Private CA by calling the ImportCertificateAuthorityCertificate action. The CSR is returned as a base64 PEM-encoded string.

    Args:
        certificate_authority_arn(str): The Amazon Resource Name (ARN) that was returned when you called the CreateCertificateAuthority action. This must be of the form:   arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.acm_pca.certificate.authority.csr.get(
                ctx, certificate_authority_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.acm_pca.certificate.authority.csr.get certificate_authority_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="acm-pca",
        operation="get_certificate_authority_csr",
        op_kwargs={"CertificateAuthorityArn": certificate_authority_arn},
    )
